<?php
// Obtener los valores de descuento y cuotas desde la configuración del plugin
function pa_get_discount_percentage() {
    return get_option('pa_discount_percentage', 20); // Por defecto 20%
}

function pa_get_number_of_installments() {
    return get_option('pa_installment_count', 3); // Por defecto 3 cuotas
}

// Función para calcular y mostrar el precio al contado (precio regular) con ID de producto
function pa_show_custom_or_calculated_price_contado($atts) {
    $atts = shortcode_atts(array(
        'product_id' => null,
    ), $atts, 'mostrar_precio_contado');

    $product_id = $atts['product_id'];
    if (!$product_id) {
        global $product;
        $product_id = $product->get_id();
    }

    // Obtener el precio personalizado al contado
    $custom_price_contado = get_post_meta($product_id, '_custom_price_contado', true);

    // Si hay un precio personalizado, usarlo, si no, calcular el precio estándar con el descuento configurado
    if (!empty($custom_price_contado)) {
        return number_format($custom_price_contando, 0, '', '.');
    } else {
        $product = wc_get_product($product_id); // Obtener el producto
        if ($product) {
            $price = (float) $product->get_regular_price(); // Utiliza el precio regular del producto
            $discount_percentage = pa_get_discount_percentage() / 100; // Obtener el descuento configurado
            $contado_price = round($price * (1 - $discount_percentage)); // Aplicar el descuento configurado
            return number_format($contado_price, 0, '', '.');
        }
    }
    return '';
}
add_shortcode('mostrar_precio_contado', 'pa_show_custom_or_calculated_price_contado');

// Función para calcular y mostrar el precio en cuotas con ID de producto
function pa_show_custom_or_calculated_price_cuota($atts) {
    $atts = shortcode_atts(array(
        'product_id' => null,
    ), $atts, 'mostrar_precio_cuota');

    $product_id = $atts['product_id'];
    if (!$product_id) {
        global $product;
        $product_id = $product->get_id();
    }

    // Obtener el precio personalizado en cuotas
    $custom_price_cuota = get_post_meta($product_id, '_custom_price_cuota', true);

    // Si hay un precio personalizado, usarlo, si no, calcular el precio estándar dividido en las cuotas configuradas
    if (!empty($custom_price_cuota)) {
        return number_format($custom_price_cuota, 0, '', '.');
    } else {
        $product = wc_get_product($product_id); // Obtener el producto
        if ($product) {
            $price = (float) $product->get_regular_price(); // Utiliza el precio regular del producto
            $installments = pa_get_number_of_installments(); // Obtener el número de cuotas configuradas
            $cuota_price = round($price / $installments); // Dividido en cuotas configuradas
            return number_format($cuota_price, 0, '', '.');
        }
    }
    return '';
}
add_shortcode('mostrar_precio_cuota', 'pa_show_custom_or_calculated_price_cuota');

// Función para calcular y mostrar el precio al contado (precio rebajado) con ID de producto
function pa_show_custom_or_calculated_price_contado_rebajado($atts) {
    $atts = shortcode_atts(array(
        'product_id' => null,
    ), $atts, 'mostrar_precio_contado_rebajado');

    $product_id = $atts['product_id'];
    if (!$product_id) {
        global $product;
        $product_id = $product->get_id();
    }

    // Obtener el precio personalizado al contado
    $custom_price_contado = get_post_meta($product_id, '_custom_price_contado', true);

    // Si hay un precio personalizado, usarlo, si no, calcular el precio rebajado con el descuento configurado
    if (!empty($custom_price_contado)) {
        return number_format($custom_price_contado, 0, '', '.');
    } else {
        $product = wc_get_product($product_id); // Obtener el producto
        if ($product) {
            $sale_price = (float) $product->get_sale_price(); // Utiliza el precio rebajado del producto
            $discount_percentage = pa_get_discount_percentage() / 100; // Obtener el descuento configurado
            if ($sale_price > 0) {
                $contado_price_rebajado = round($sale_price * (1 - $discount_percentage)); // Aplicar el descuento configurado
                return number_format($contado_price_rebajado, 0, '', '.');
            } else {
                // Si no hay un precio de oferta, usa el precio regular
                return pa_show_custom_or_calculated_price_contado(array('product_id' => $product_id));
            }
        }
    }
    return '';
}
add_shortcode('mostrar_precio_contado_rebajado', 'pa_show_custom_or_calculated_price_contado_rebajado');

// Función para calcular y mostrar el precio en cuotas (precio rebajado) con ID de producto
function pa_show_custom_or_calculated_price_cuota_rebajado($atts) {
    $atts = shortcode_atts(array(
        'product_id' => null,
    ), $atts, 'mostrar_precio_cuota_rebajado');

    $product_id = $atts['product_id'];
    if (!$product_id) {
        global $product;
        $product_id = $product->get_id();
    }

    // Obtener el precio personalizado en cuotas
    $custom_price_cuota = get_post_meta($product_id, '_custom_price_cuota', true);

    // Si hay un precio personalizado, usarlo, si no, calcular el precio rebajado dividido en las cuotas configuradas
    if (!empty($custom_price_cuota)) {
        return number_format($custom_price_cuota, 0, '', '.');
    } else {
        $product = wc_get_product($product_id); // Obtener el producto
        if ($product) {
            $sale_price = (float) $product->get_sale_price(); // Utiliza el precio rebajado del producto
            $installments = pa_get_number_of_installments(); // Obtener el número de cuotas configuradas
            if ($sale_price > 0) {
                $cuota_price_rebajado = round($sale_price / $installments); // Dividido en cuotas configuradas
                return number_format($cuota_price_rebajado, 0, '', '.');
            } else {
                // Si no hay un precio de oferta, usa el precio regular
                return pa_show_custom_or_calculated_price_cuota(array('product_id' => $product_id));
            }
        }
    }
    return '';
}
add_shortcode('mostrar_precio_cuota_rebajado', 'pa_show_custom_or_calculated_price_cuota_rebajado');
?>